Ext.define('Photoalbum.model.Picasa', {
	extend: 'Ext.data.Model',
    fields: [
        {name: 'id', type: 'string'},
        {name: 'url', type: 'string'},
        {name: 'width', type: 'int'},
        {name: 'height', type: 'int'},
        {name: 'audio', type: 'string',
            convert: function(value, record) {
                var summary   = record.data.summary;
                if(summary.substring(0,7)=='http://' && summary.substring(summary.length-4,summary.length)=='.mp3')
                	return summary;
                else return '';
            }
        },
        {name: 'description', type: 'string',
            convert: function(value, record) {
                if(record.get('audio')=='')
                	return record.data.summary;
                else return '';
            }
        }
    ],
    
    resize: function(factor) { 
    	var width = this.get('width'),
    		height = this.get('height'),
    		ratio = parseFloat(width / height);
    	if(width>height && (width*factor)>600) {
    		width = parseFloat(600/factor); height = parseFloat(width/ratio);
    	} else if((height*factor)>600) {
    		height = parseFloat(600/factor); width= parseFloat(height*ratio);
    	}
    	this.set('width',parseInt(width * factor));
    	this.set('height',parseInt(height * factor));
    },
    
    summaryupdate: false,
    tagupdate: false,
    commentupdate: false,
    locationupdate: false,
    
});